/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.ImageSetButton;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.client.util.FileChooserUtils;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.util.FlagThread;
import dev.felnull.otyacraftengine.util.OEImageUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImageNameBaseMMMonitor
extends MusicManagerMonitor {
    private static final Gson GSON = new Gson();
    private static final class_2960 SET_IMAGE_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/image_set_base.png");
    private static final class_2561 IMAGE_TEXT = class_2561.method_43471((String)"imp.text.image");
    private static final class_2561 NO_IMAGE_TEXT = class_2561.method_43471((String)"imp.text.noImage");
    private static final class_2561 DROP_INFO_TEXT = class_2561.method_43471((String)"imp.text.dropInfo");
    private static final class_2561 NAME_TEXT = class_2561.method_43471((String)"imp.text.name");
    private static final class_2561 BACK_TEXT = class_2561.method_43471((String)"gui.back");
    private static final class_2561 UPLOADING_IMAGE_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.uploadImage");
    private boolean locked;
    private class_2561 NOT_ENTERED_TEXT;
    private class_2561 IMAGE_SET_ERROR_TEXT;
    protected class_342 nameEditBox;
    private SmartButton doneButton;
    private ImageUrlLoader imageUrlLoader;
    private ImageUploader imageUploader;
    private List<class_2561> lastNotEnteredTexts;

    public ImageNameBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        if (!this.isLocked()) {
            if (this.getScreen().musicFileImage != null) {
                this.startImageUpload(this.getScreen().musicFileImage);
                this.getScreen().musicFileImage = null;
            }
            this.addRenderWidget(new ImageSetButton(this.getStartX() + 149, this.getStartY() + 22, ImageSetButton.ImageSetType.DELETE, n -> this.setImage(ImageInfo.EMPTY), (class_437)this.getScreen()));
            this.addRenderWidget(new ImageSetButton(this.getStartX() + 112, this.getStartY() + 22, ImageSetButton.ImageSetType.FILE_OPEN, n -> this.openImage(FileChooserUtils.openImageFileChooser(false)), (class_437)this.getScreen()));
            this.addRenderWidget(new ImageSetButton(this.getStartX() + 75, this.getStartY() + 22, ImageSetButton.ImageSetType.PLAYER_FACE, n -> this.setImage(new ImageInfo(ImageInfo.ImageType.PLAYER_FACE, IIMPSmartRender.mc.field_1724.method_7334().getName())), (class_437)this.getScreen()));
        }
        this.nameEditBox = new class_342(IIMPSmartRender.mc.field_1772, this.getStartX() + 5, this.getStartY() + 112, 177, 12, (class_2561)class_2561.method_43471((String)"imp.editBox.name"));
        this.nameEditBox.method_1880(300);
        this.nameEditBox.method_1852(this.getName());
        this.nameEditBox.method_1863(this::setName);
        this.addRenderWidget(this.nameEditBox);
        this.nameEditBox.method_1888(!this.isLocked());
        this.addRenderWidget(new SmartButton(this.getStartX() + 5, this.getStartY() + 180, 87, 15, BACK_TEXT, n -> {
            if (this.getDoneType() == null) {
                class_2586 patt5214$temp = this.getScreen().getBlockEntity();
                if (patt5214$temp instanceof MusicManagerBlockEntity) {
                    MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)patt5214$temp;
                    boolean bf = true;
                    if (this.canDone(musicManagerBlockEntity)) {
                        bf = this.done(this.getImage(), this.getName());
                    }
                    if (bf) {
                        MusicManagerBlockEntity.MonitorType pt = this.getParentType();
                        if (pt == null) {
                            pt = MusicManagerBlockEntity.MonitorType.PLAY_LIST;
                        }
                        this.insMonitor(pt);
                    }
                }
            } else {
                MusicManagerBlockEntity.MonitorType pt = this.getParentType();
                if (pt == null) {
                    pt = MusicManagerBlockEntity.MonitorType.PLAY_LIST;
                }
                this.insMonitor(pt);
            }
        }));
        if (this.getDoneType() != null) {
            this.doneButton = this.addRenderWidget(new SmartButton(this.getStartX() + 95, this.getStartY() + 180, 87, 15, this.getDoneType().getText(), n -> {
                MusicManagerBlockEntity musicManagerBlockEntity;
                class_2586 patt6091$temp = this.getScreen().getBlockEntity();
                if (patt6091$temp instanceof MusicManagerBlockEntity && this.canDone(musicManagerBlockEntity = (MusicManagerBlockEntity)patt6091$temp) && this.done(this.getImage(), this.getName())) {
                    this.insMonitor(this.getDoneBackMonitor());
                }
            }));
            class_2586 class_25862 = this.getScreen().getBlockEntity();
            if (class_25862 instanceof MusicManagerBlockEntity) {
                MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
                this.doneButton.field_22763 = this.canDone(musicManagerBlockEntity);
            }
        }
    }

    @NotNull
    protected MusicManagerBlockEntity.MonitorType getDoneBackMonitor() {
        return MusicManagerBlockEntity.MonitorType.PLAY_LIST;
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((class_2960)SET_IMAGE_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        this.drawSmartText(poseStack, IMAGE_TEXT, this.getStartX() + 5, this.getStartY() + 13);
        if (!this.getImage().isEmpty()) {
            PlayImageRenderer.getInstance().draw(this.getImage(), poseStack, this.getStartX() + 6, this.getStartY() + 23, 64.0f, false);
        } else {
            this.drawSmartCenterText(poseStack, NO_IMAGE_TEXT, this.getStartX() + 38, this.getStartY() + 51);
        }
        if (!this.isLocked()) {
            this.drawSmartText(poseStack, DROP_INFO_TEXT, this.getStartX() + 5, this.getStartY() + 90);
            if (this.imageUploader != null && this.imageUploader.isAlive()) {
                this.drawSmartFixedWidthText(poseStack, UPLOADING_IMAGE_TEXT, this.getStartX() + 75, this.getStartY() + 59, 107.0f);
            } else if (this.IMAGE_SET_ERROR_TEXT != null) {
                this.drawSmartFixedWidthText(poseStack, this.IMAGE_SET_ERROR_TEXT, this.getStartX() + 75, this.getStartY() + 59, 107.0f, -65536);
            }
            if (this.NOT_ENTERED_TEXT != null) {
                this.drawSmartFixedWidthText(poseStack, this.NOT_ENTERED_TEXT, this.getStartX() + 5, this.getStartY() + 171, 177.0f, -40121);
            }
        }
        this.drawSmartText(poseStack, NAME_TEXT, this.getStartX() + 5, this.getStartY() + 102);
    }

    public abstract boolean done(ImageInfo var1, String var2);

    public boolean canDone(MusicManagerBlockEntity blockEntity) {
        return !this.getName(blockEntity).isEmpty();
    }

    public List<class_2561> getNotEntered(List<class_2561> names, MusicManagerBlockEntity blockEntity) {
        if (this.getName(blockEntity).isEmpty()) {
            names.add(NAME_TEXT);
        }
        return names;
    }

    private void updateNotEnteredText() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            List<class_2561> notEnteredTexts = this.getNotEntered(new ArrayList<class_2561>(), musicManagerBlockEntity);
            if (!notEnteredTexts.equals(this.lastNotEnteredTexts)) {
                if (!this.canDone(musicManagerBlockEntity)) {
                    StringBuilder sb = new StringBuilder();
                    for (class_2561 notEnteredText : notEnteredTexts) {
                        sb.append(notEnteredText.getString()).append(", ");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.deleteCharAt(sb.length() - 1);
                    this.NOT_ENTERED_TEXT = class_2561.method_43469((String)"imp.text.notEntered", (Object[])new Object[]{sb.toString()});
                    if (this.getDoneType() != null) {
                        this.doneButton.field_22763 = false;
                    }
                } else {
                    this.NOT_ENTERED_TEXT = null;
                    if (this.getDoneType() != null) {
                        this.doneButton.field_22763 = true;
                    }
                }
                this.lastNotEnteredTexts = notEnteredTexts;
            }
        } else {
            this.NOT_ENTERED_TEXT = null;
            if (this.getDoneType() != null) {
                this.doneButton.field_22763 = false;
            }
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((class_2960)SET_IMAGE_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartTextSprite(poseStack, multiBufferSource, IMAGE_TEXT, 5.0f, 13.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        ImageInfo img = this.getImage(blockEntity);
        float sc = onPxW / onPxH;
        float sch = onPxH / onPxW;
        if (!img.isEmpty()) {
            poseStack.method_22903();
            poseStack.method_22905(sc, 1.0f, 1.0f);
            PlayImageRenderer.getInstance().renderSprite(img, poseStack, multiBufferSource, 6.0f * onPxW / sc, monitorHeight - 87.0f * onPxH, 0.004f, 64.0f * onPxH, i, j, false);
            poseStack.method_22909();
        } else {
            int strl = IIMPSmartRender.mc.field_1772.method_27525((class_5348)NO_IMAGE_TEXT);
            this.renderSmartTextSprite(poseStack, multiBufferSource, NO_IMAGE_TEXT, 6.0f + (38.0f * sc - (float)strl / 2.0f), 51.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        }
        if (!this.isLocked()) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, 149.0f, 22.0f, 0.004f, 33.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 84, 19, 11, 11, 256, 256);
            this.renderSmartButtonSprite(poseStack, multiBufferSource, 112.0f, 22.0f, 0.004f, 33.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 73, 19, 11, 11, 256, 256);
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 75.0f, 22.0f, 0.004f, 33.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight);
            poseStack.method_22903();
            poseStack.method_22904((double)(onPxW * 86.0f), (double)(monitorHeight - onPxH * (22.0f + 2.0f * sch) - 11.0f * onPxW), (double)0.006f);
            OERenderUtils.renderPlayerFaceSprite((class_4587)poseStack, (class_4597)multiBufferSource, (UUID)IIMPSmartRender.mc.field_1724.method_7334().getId(), (float)(11.0f * onPxW), (int)i, (int)j);
            poseStack.method_22909();
            this.renderSmartTextSprite(poseStack, multiBufferSource, DROP_INFO_TEXT, 5.0f, 90.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
            if (!this.canDone(blockEntity)) {
                StringBuilder sb = new StringBuilder();
                for (class_2561 notEnteredText : this.getNotEntered(new ArrayList<class_2561>(), blockEntity)) {
                    sb.append(notEnteredText.getString()).append(", ");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
                this.renderSmartTextSpriteColorSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43469((String)"imp.text.notEntered", (Object[])new Object[]{sb.toString()}), 5.0f, 171.0f, 0.004f, onPxW, onPxH, monitorHeight, -40121, i);
            }
        }
        this.renderSmartTextSprite(poseStack, multiBufferSource, NAME_TEXT, 5.0f, 102.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 5.0f, 112.0f, 0.004f, 177.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getName(blockEntity));
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 5.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, BACK_TEXT, true);
        if (this.getDoneType() != null) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, 95.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, this.getDoneType().getText(), true, !this.canDone(blockEntity));
        }
    }

    protected void locked() {
        this.locked = true;
    }

    private boolean isLocked() {
        return this.locked;
    }

    @Override
    public void depose() {
        super.depose();
        this.stopImageUrlLoad();
        this.stopImageUpload();
    }

    @Override
    public void onFilesDrop(List<Path> list) {
        if (this.isLocked()) {
            return;
        }
        File[] files = new File[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            files[i] = list.get(i).toFile();
        }
        this.openImage(files);
    }

    @NotNull
    protected String getName() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getName(musicManagerBlockEntity);
        }
        return "";
    }

    @NotNull
    protected String getName(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getCreateName((class_1657)ImageNameBaseMMMonitor.mc.field_1724);
    }

    protected void setName(@NotNull String name) {
        this.getScreen().insCreateName(name);
    }

    @NotNull
    protected ImageInfo getImage() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImage(musicManagerBlockEntity);
        }
        return ImageInfo.EMPTY;
    }

    @NotNull
    protected ImageInfo getImage(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getImage((class_1657)ImageNameBaseMMMonitor.mc.field_1724);
    }

    protected void setImage(ImageInfo image) {
        this.getScreen().insImage(image);
    }

    private void startImageUrlLoad(String url) {
        this.stopImageUrlLoad();
        this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.loadingImage");
        this.imageUrlLoader = new ImageUrlLoader(url);
        this.imageUrlLoader.start();
    }

    private void stopImageUrlLoad() {
        if (this.imageUrlLoader != null) {
            this.imageUrlLoader.stopped();
            this.imageUrlLoader = null;
        }
        this.IMAGE_SET_ERROR_TEXT = null;
    }

    private void startImageUpload(byte[] data) {
        this.stopImageUpload();
        this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.loadingImage");
        this.imageUploader = new ImageUploader(data);
        this.imageUploader.start();
    }

    private void stopImageUpload() {
        if (this.imageUploader != null) {
            this.imageUploader.stopped();
            this.imageUploader = null;
        }
        this.IMAGE_SET_ERROR_TEXT = null;
    }

    private void openImage(File[] files) {
        if (this.isLocked()) {
            return;
        }
        if (files == null || files.length == 0) {
            return;
        }
        if (files.length != 1) {
            this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.tooManyImages");
            return;
        }
        this.IMAGE_SET_ERROR_TEXT = null;
        File file = files[0];
        if (file.isDirectory()) {
            this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.directory");
            return;
        }
        if (file.exists()) {
            try {
                this.startImageUpload(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                this.IMAGE_SET_ERROR_TEXT = class_2561.method_43469((String)"imp.text.imageLoad.error", (Object[])new Object[]{e.getMessage()});
                e.printStackTrace();
            }
        } else {
            this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.fileNotFound");
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.updateNotEnteredText();
    }

    @Nullable
    protected abstract DoneType getDoneType();

    public static enum DoneType {
        CREATE((class_2561)class_2561.method_43471((String)"imp.button.create")),
        ADD((class_2561)class_2561.method_43471((String)"imp.button.add")),
        SAVE((class_2561)class_2561.method_43471((String)"imp.button.save")),
        IMPORT((class_2561)class_2561.method_43471((String)"imp.button.import"));

        private final class_2561 text;

        private DoneType(class_2561 text) {
            this.text = text;
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    private class ImageUploader
    extends FlagThread {
        private byte[] data;

        private ImageUploader(byte[] data) {
            this.data = data;
        }

        public void run() {
            if (this.isStopped()) {
                return;
            }
            try {
                String url;
                if (!OEImageUtils.isImage((byte[])this.data)) {
                    ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.notImage");
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
                long max = 0x300000L;
                if ((long)this.data.length > max) {
                    ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.optimizationImage");
                    this.data = OEImageUtils.reductionSize((byte[])this.data, (long)(max - 100L));
                }
                if (this.isStopped()) {
                    return;
                }
                Files.write(Paths.get("test.gif", new String[0]), this.data, new OpenOption[0]);
                try {
                    if (this.isStopped()) {
                        return;
                    }
                    url = this.uploadToImgur(this.data);
                    if (this.isStopped()) {
                        return;
                    }
                }
                catch (IOException e) {
                    ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = class_2561.method_43469((String)"imp.text.imageLoad.uploadFailure", (Object[])new Object[]{e.getMessage()});
                    e.printStackTrace();
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
                ImageNameBaseMMMonitor.this.setImage(new ImageInfo(ImageInfo.ImageType.URL, url));
                ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = null;
            }
            catch (Exception e) {
                ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = class_2561.method_43469((String)"imp.text.imageLoad.error", (Object[])new Object[]{e.getLocalizedMessage()});
                e.printStackTrace();
            }
        }

        private String uploadToImgur(byte[] data) throws IOException, InterruptedException {
            if (this.isStopped()) {
                return null;
            }
            HttpClient hc = HttpClient.newHttpClient();
            HttpRequest hr = HttpRequest.newBuilder(URI.create("https://api.imgur.com/3/image")).POST(HttpRequest.BodyPublishers.ofByteArray(data)).header("Authorization", "Client-ID 9a0189f3c8b74b9").build();
            if (this.isStopped()) {
                return null;
            }
            HttpResponse<String> res = hc.send(hr, HttpResponse.BodyHandlers.ofString());
            if (this.isStopped()) {
                return null;
            }
            JsonObject upData = (JsonObject)GSON.fromJson(res.body(), JsonObject.class);
            if (upData.getAsJsonObject("data") == null || upData.getAsJsonObject("data").get("link") == null) {
                throw new IOException("code " + upData.get("status").getAsInt());
            }
            return upData.getAsJsonObject("data").get("link").getAsString();
        }
    }

    private class ImageUrlLoader
    extends FlagThread {
        private final String url;

        private ImageUrlLoader(String url) {
            this.url = url;
        }

        public void run() {
            if (this.isStopped()) {
                return;
            }
            try {
                HttpURLConnection urll = FNURLUtil.getConnection(new URL(this.url));
                if (this.isStopped()) {
                    return;
                }
                long max = 0x300000L;
                if (urll.getContentLengthLong() > max) {
                    ImageNameBaseMMMonitor.this.startImageUpload(urll.getInputStream().readAllBytes());
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
                byte[] img = urll.getInputStream().readAllBytes();
                if (this.isStopped()) {
                    return;
                }
                if (!OEImageUtils.isImage((byte[])img)) {
                    ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = class_2561.method_43471((String)"imp.text.imageLoad.notImageUrl");
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
                ImageNameBaseMMMonitor.this.setImage(new ImageInfo(ImageInfo.ImageType.URL, this.url));
                if (this.isStopped()) {
                    return;
                }
                ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = null;
            }
            catch (Exception e) {
                ImageNameBaseMMMonitor.this.IMAGE_SET_ERROR_TEXT = class_2561.method_43469((String)"imp.text.imageLoad.error", (Object[])new Object[]{e.getLocalizedMessage()});
            }
        }
    }
}

